<%@ Page Title="" Language="C#" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="VIRP_WEB.Custom.BPR.Registrants.RegistrantSearch" Codebehind="RegistrantSearch.aspx.cs" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlDropDownList.ascx" tagname="BaseControlDropDownList" tagprefix="UserControl" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlTextBox.ascx" tagname="BaseControlTextBox" tagprefix="UserControl" %>
<%@ Register src="~/Controls/Custom/BPR/UserControlDate.ascx" tagname="UserControlBirthDate" tagprefix="UserControl" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <script type = "text/javascript">
        $(document).ready(function() {
            $('.textInput').change(function() {
                $('#<%= PanelRegistrantsList.ClientID %>').hide();
            });
        });
    </script>
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Registrants > Registrant Search"/>
    </div>    
    <asp:Panel ID="PanelSearchCriteria" runat="server" GroupingText="Registrant Search Criteria">
    <table>
        <tr>
            <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxLastName" runat="server" /></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
            <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxLast4SSN" runat="server" /></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
            <td>
                 <UserControl:UserControlBirthDate ID="UserControlBirthDate" runat="server" />   
            </td>
        </tr>
        <tr>
            <td colspan="2"><UserControl:BaseControlDropDownList ID="BaseControlDropdownListRegistryStatus" runat="server" /></td>
            <td colspan="2"><UserControl:BaseControlDropDownList ID="BaseControlDropdownListRegistryFlag" runat="server" /></td>
            <td>
                <asp:Label SkinID="DataLabel" ID="Label1" runat="server" AssociatedControlID="TextBoxRegistrantId">Registrant ID:</asp:Label>
                <br /><asp:TextBox runat="server" ID="TextBoxRegistrantId" MaxLength="20" Width="200"  class='textInput' />
                <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="TextBoxRegistrantId" 
                    EnableClientScript="true" Enabled="true" ValidationGroup="SearchRegistrant"
                    ErrorMessage="Please enter only numbers" ForeColor="Red" ValidationExpression="^\d+$">
                </asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr>
            <td>
                <asp:Button ID="Search" runat="server" onclick="Search_Click" Text="Search" ValidationGroup="SearchRegistrant" />
                &nbsp;&nbsp;&nbsp;&nbsp;<asp:Button ID="ButtonClear" runat="server" Text=" Clear " onclick="ButtonClear_Click" CausesValidation="false" />
            </td>
       </tr>
    </table>
    <asp:CustomValidator ID="CustomValidatorSearchCriteria" runat="server" ErrorMessage="Please enter at least one of the following fields: Last Name, Last 4 of SSN, Date of Birth, Registry Status, or Registry Flags."
    ValidationGroup="SearchRegistrant" ForeColor="Red"></asp:CustomValidator>

    <asp:ObjectDataSource 
        ID="RegistrantSearchDS" runat="server" 
            SelectMethod="SearchRegistrants" 
            SelectCountMethod="SearchRegistrantsCount"
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True"  
            TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager" 
            onselected="RegistrantSearchDS_Selected">
        <SelectParameters>
            <asp:ControlParameter ControlID="BaseControlTextBoxLastName" Name="lastName" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="BaseControlTextBoxLast4SSN" Name="last4SSN" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="UserControlBirthDate" Name="dob" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="BaseControlDropdownListRegistryStatus" Name="registryStatusId" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="BaseControlDropdownListRegistryFlag" Name="registryFlagId" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="TextBoxRegistrantId" Name="registrantId" PropertyName="Text" Type="String" />
            <asp:Parameter Name="sort" Type="String" />
            <asp:Parameter Name="startRow" Type="Int32" />
            <asp:Parameter Name="maxRows" Type="Int32" />
            <asp:Parameter Name="totalRecords" Type="Int32" Direction="Output" />
       </SelectParameters>
    </asp:ObjectDataSource>
    </asp:Panel>
    <asp:Panel ID="PanelRegistrantsList" runat="server">
            <asp:Label runat="server" ID="LabelNumberOfRegistrantsFound" Font-Bold="true"></asp:Label>
            <div style='text-align: right' runat='server' id='pageSizeDiv'>
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="false" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat='server' ID='gridViewPageSizeDdl' AutoPostBack='true' Visible="false" CausesValidation='false' ToolTip="Items per page"
                        OnSelectedIndexChanged='gridViewPageSizeDdlChanged'>
                        <asp:ListItem Text='10' Value='10'></asp:ListItem>
                        <asp:ListItem Text='25' Value='25'></asp:ListItem>
                        <asp:ListItem Text='50' Value='50'></asp:ListItem>
                        <asp:ListItem Text='100' Value='100'></asp:ListItem>
                    </asp:DropDownList>
            </div>
            <asp:GridView 
                ID="GridViewRegistrant" 
                runat="server" 
                OnRowCommand = "GridViewRegistrant_RowCommand"
                AutoGenerateColumns="False" Width="100%"
                DataSourceID="RegistrantSearchDS"
                AllowPaging="True" 
                AllowSorting="True" 
                Visible="False" 
                Caption="To sort please click table headings" 
                EnableModelValidation="True"
                DataKeyNames="REGISTRANT_ID" 
                PagerSettings-Mode="Numeric"
                onrowdatabound="GridViewRegistrant_RowDataBound"
                OnPageIndexChanging='gridView_PageIndexChanging'>
            <EmptyDataTemplate>No match found. Please verify the information you entered in the search criteria.</EmptyDataTemplate>
            <Columns>
                <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" ValidationGroup="SearchRegistrant"
                   ItemStyle-VerticalAlign="Middle" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText = "Select" HeaderText ="Action" />
                <asp:TemplateField HeaderText="ID" SortExpression="REGISTRANT_ID" AccessibleHeaderText="ID" >
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelRegistrantId" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("REGISTRANT_ID")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Registrant Name" SortExpression="LAST_NAME, FIRST_NAME">
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID="LabelRegistrantLastName" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Name"))  %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="Last 4 of SSN">
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID="LabelLast4Ssn" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Last4Ssn"))  %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="Date of Birth" SortExpression="BIRTH_DATE">
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID="LabelDateOfBirth" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Dob"))  %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="Duty Status" SortExpression="STD_SERVICE_STATUS.SERVICE_STATUS" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelServiceStatus" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("STD_SERVICE_STATUS.SERVICE_STATUS")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                
                <asp:TemplateField HeaderText="Registrant Current Status" SortExpression="STD_REGISTRANT_STATUS.ORDINAL_VALUE">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelRegistryStatus" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("STD_REGISTRANT_STATUS.REGISTRANT_STATUS")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="Questionnaire Completion<br />Date and Time">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelCompletionDate" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("QuestionnaireCompletionDateTime")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Reports Health Concerns?" >
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelReportsHealthConcerns" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("ReportsHealthConcerns")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Request to be Seen?" >
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelRequestToBeSeen" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("RequestToBeSeen")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
            </Columns>
        </asp:GridView>
       </asp:Panel>


</asp:Content>

